# -*- coding: utf-8 -*-
#   Copyright (C) 2008-2009 Team XBMC http://www.xbmc.org
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# PS3 Remote and Controller Keymaps

keymap_remote = {
    "16": 'power',  # EJECT
    "64": None,  # AUDIO
    "65": None,  # ANGLE
    "63": None,  # SUBTITLE
    "0f": None,  # CLEAR
    "28": None,  # TIME

    "00": 'one',  # 1
    "01": 'two',  # 2
    "02": 'three',  # 3
    "03": 'four',  # 4
    "04": 'five',  # 5
    "05": 'six',  # 6
    "06": 'seven',  # 7
    "07": 'eight',  # 8
    "08": 'nine',  # 9
    "09": 'zero',  # 0

    "81": 'mytv',  # RED
    "82": 'mymusic',  # GREEN
    "80": 'mypictures',  # BLUE
    "83": 'myvideo',  # YELLOW

    "70": 'display',  # DISPLAY
    "1a": None,  # TOP MENU
    "40": 'menu',  # POP UP/MENU
    "0e": None,  # RETURN

    "5c": 'menu',  # OPTIONS/TRIANGLE
    "5d": 'back',  # BACK/CIRCLE
    "5e": 'info',  # X
    "5f": 'title',  # VIEW/SQUARE

    "54": 'up',  # UP
    "55": 'right',  # RIGHT
    "56": 'down',  # DOWN
    "57": 'left',  # LEFT
    "0b": 'select',  # ENTER

    "5a": 'volumeplus',  # L1
    "58": 'volumeminus',  # L2
    "51": 'Mute',  # L3
    "5b": 'pageplus',  # R1
    "59": 'pageminus',  # R2
    "52": None,  # R3

    "43": None,  # PLAYSTATION
    "50": None,  # SELECT
    "53": None,  # START

    "33": 'reverse',  # <-SCAN
    "34": 'forward',  # SCAN->
    "30": 'skipminus',  # PREV
    "31": 'skipplus',  # NEXT
    "60": None,  # <-SLOW/STEP
    "61": None,  # SLOW/STEP->
    "32": 'play',  # PLAY
    "38": 'stop',  # STOP
    "39": 'pause',  # PAUSE
}
